/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// Logarithmic Spiral Nautilus - written 2015-12-03 by Jakob Thomsen
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// Thanks to FabriceNeyret2 for optimizations

void mainImage( out vec4 O, vec2 I )
{
	vec2 R = iResolution.xy; 
    I = (I+I-R)/R.y;
    float a = atan(I.y, I.x);
    I = vec2(0, .1*iGlobalTime + log2(length(I))) - a / 6.283;
    I = vec2((ceil(I.y) - I.x) * 2.4, fract(I.y)); // approximation to golden angle pi*(3-sqrt(5)
    
    float b = 2.*fract(I.y)-1.; // b in [-1,+1]
    vec3 n = normalize(vec3(b*cos(a),b*sin(a),1.- b*b)); // b^2*cos^2+b^2*sin^2+(1-b^2) should be 1 but normalize changes it?!

    float t = iGlobalTime;
    // position light on trefoil-knot curve to make it more interesting
    // position light relatively high (otherwise it becomes obvious that intersections/shadows are missing)
    vec3 l = normalize(vec3(sin(t) + 2.*sin(2.*t), cos(t) - 2.*cos(2.*t),5.-sin(3.*t)));
    float d = max(dot(n,l),0.);
    float s = max(pow(dot(n,normalize(l+vec3(0,0,1))),50.),0.);
    O = (d+s) * mix(texture2D(iChannel0, I),texture2D(iChannel2, I*.1),texture2D(iChannel1, I*.1));
}

void main ( void )
{ mainImage ( gl_FragColor, gl_FragCoord.xy );
}